/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.config.json;

import com.fuzs.puzzleslib_em.config.json.JsonConfigFileUtil;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class JsonCommandUtil {
    public static LiteralArgumentBuilder<CommandSource> createReloadCommand(String jsonName, String modId, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        return JsonCommandUtil.createReloadCommand(jsonName, modId, "command.reload." + jsonName.replace(".json", ""), serializer, deserializer);
    }

    public static LiteralArgumentBuilder<CommandSource> createReloadCommand(String jsonName, String modId, String translationKey, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        return (LiteralArgumentBuilder)Commands.func_197057_a((String)modId).then(Commands.func_197057_a((String)"reload").executes(ctx -> {
            JsonCommandUtil.handleFileReload((CommandContext<CommandSource>)ctx, jsonName, translationKey, serializer, deserializer);
            return 1;
        }));
    }

    public static void handleFileReload(CommandContext<CommandSource> ctx, String jsonName, String translationKey, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        JsonCommandUtil.handleFolderReload(ctx, jsonName, null, translationKey, serializer, deserializer);
    }

    public static void handleFolderReload(CommandContext<CommandSource> ctx, String jsonName, @Nullable String modId, String translationKey, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        JsonCommandUtil.reloadJsonConfig(jsonName, modId, serializer, deserializer);
        JsonCommandUtil.sendFeedback(ctx, jsonName, modId, translationKey);
    }

    private static void reloadJsonConfig(String jsonName, @Nullable String modId, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        if (modId != null) {
            JsonConfigFileUtil.getAndLoad(jsonName, modId, serializer, deserializer);
        } else {
            JsonConfigFileUtil.getAndLoad(jsonName, serializer, deserializer);
        }
    }

    private static void sendFeedback(CommandContext<CommandSource> ctx, String jsonName, @Nullable String modId, String translationKey) {
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)JsonCommandUtil.getFeedbackComponent(jsonName, modId, translationKey), true);
    }

    private static IFormattableTextComponent getFeedbackComponent(String jsonName, @Nullable String modId, String translationKey) {
        return new TranslationTextComponent(translationKey, new Object[]{JsonCommandUtil.getClickableComponent(jsonName, modId)});
    }

    private static IFormattableTextComponent getClickableComponent(String jsonName, @Nullable String modId) {
        File filePath = modId != null ? JsonConfigFileUtil.getPathInDir(jsonName, modId) : JsonConfigFileUtil.getPath(jsonName);
        return new StringTextComponent(jsonName).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath.getAbsolutePath())));
    }
}

